  //@author: dottore
  //@description: combines RGB from the first texture and A from the second texture
  //@tags:
  //@credits: ShaderX3 book (chapter 4.4 ; Improved Depth-of-Field Rendering; Thorsten Scheuermann and Natalya Tararchuk)


// --------------------------------------------------------------------------------------------------
// PARAMETERS:
// --------------------------------------------------------------------------------------------------

//transforms
float4x4 tWVP: WORLD;        //the models world matrix

//texture
texture TexRGB <string uiname="RGB Texture";>;
sampler SampRGB = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexRGB);          //apply a texture to the sampler
    MipFilter = none;         //sampler states
    MinFilter = none;
    MagFilter = none;
};

//texture
texture TexA <string uiname="A Texture";>;
sampler SampA = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (TexA);          //apply a texture to the sampler
    MipFilter = none;         //sampler states
    MinFilter = none;
    MagFilter = none;
};

//the data structure: "vertexshader to pixelshader"
//used as output data with the VS function
//and as input data with the PS function
struct vs2ps
{
    float4 Pos  : POSITION;
    float2 TexCd : TEXCOORD0;
};

// --------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// --------------------------------------------------------------------------------------------------
vs2ps VS(
    float4 PosO  : POSITION,
    float2 TexCd : TEXCOORD0)
{
    //declare output struct
    vs2ps Out;

    //transform position
    Out.Pos = mul(PosO, tWVP);
    
    //transform texturecoordinates
    Out.TexCd = TexCd;

    return Out;
}

// --------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// --------------------------------------------------------------------------------------------------

float4 PS(vs2ps In): COLOR
{
    float4 col = tex2D(SampRGB, In.TexCd);
    col.a = tex2D(SampA, In.TexCd).r;
    return col;
}

// --------------------------------------------------------------------------------------------------
// TECHNIQUES:
// --------------------------------------------------------------------------------------------------

technique TSimpleShader
{
    pass P0
    {
        //Wrap0 = U;  // useful when mesh is round like a sphere
        AlphaBlendEnable = false;
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_1_4 PS();
    }
}
